import { attachOpenSettingsListener } from "./common.js";
import { LOGEVENTS, MESSAGE_TYPES } from "./constants.js";
import { setupUUID } from "./user.js";

function debugDeleteUUID() {
  chrome.storage.local.remove('uuid').then(() => {
    console.info('UUID deleted successfully.');
    document.querySelector('.debugOutput').textContent = "UUID deleted";
  }).catch(error => {
    console.error('Error deleting UUID:', error);
    document.querySelector('.debugOutput').textContent = "Error deleting UUID";
  });
}

function debugResetPolicies() {
  chrome.storage.local.remove('policies').then(() => {
    console.info('Policies reset successfully.');
    document.querySelector('.debugOutput').textContent = "Policies reset";
  }).catch(error => {
    console.error('Error resetting policies:', error);
    document.querySelector('.debugOutput').textContent = "Error resetting policies";
  });
}

function debugGetAllPolicies() {
  getAllPolicy().then(policies => {
    console.info('All Policies:', policies);
    const main = document.querySelector('main');
    main.innerHTML = '';
    if (policies) {
      Object.keys(policies).forEach(baseUrl => {
        const policy = policies[baseUrl];
        const details = document.createElement('details');
        details.innerHTML = `<summary>${baseUrl}</summary><p>Status: ${policy.status}</p>`;
        if (policy.links) {
          const linksList = document.createElement('ul');
          policy.links.forEach(link => {
            const li = document.createElement('li');
            li.textContent = link;
            linksList.appendChild(li);
          });
          details.appendChild(linksList);
        }
        main.appendChild(details);
      });
    } else {
      main.innerHTML = `<details><summary>No Policies Found</summary><p>No policies are currently stored.</p></details>`;
    }
  }).catch(error => {
    console.error('Error fetching all policies:', error);
  });
}

document.addEventListener("DOMContentLoaded", () => {
  chrome.runtime.sendMessage({ type: MESSAGE_TYPES.LOG, action: LOGEVENTS.OPEN_POPUP, message: 'Popup opened' });

  attachOpenSettingsListener();
  setupUUID();

  document.getElementById('debugButtonDelete').addEventListener('click', debugDeleteUUID);
  document.getElementById('debugButtonReset').addEventListener('click', debugResetPolicies);
  document.getElementById('debugButtonGetPolicies').addEventListener('click', debugGetAllPolicies);
  document.querySelector('header .icons .open-popup')
    .addEventListener('click', () => chrome.runtime.sendMessage({
      type: MESSAGE_TYPES.LOG,
      action: LOGEVENTS.NAVIGATE_TO_VIOLATIONS,
      message: 'Popup opened',
    }));
});


document.addEventListener('beforeunload', () => {
  chrome.runtime.sendMessage({
    type: MESSAGE_TYPES.LOG,
    action: LOGEVENTS.CLOSE_POPUP,
    message: 'Popup about to be closed',
  });
});


document.addEventListener("visibilitychange", () => {
  if (document.visibilityState === "visible") {
    chrome.runtime.sendMessage({ type: MESSAGE_TYPES.LOG, action: LOGEVENTS.OPEN_POPUP, message: 'Popup opened' });
  } else {
    chrome.runtime.sendMessage({ type: MESSAGE_TYPES.LOG, action: LOGEVENTS.CLOSE_POPUP, message: 'Popup closed' });
  }
});
