export const API_ENDPOINT = 'https://p4p.medien.ifi.lmu.de/api/';

export const STORAGE_KEYS = Object.freeze({
  POLICIES: 'policies',
  PREFERENCES: 'preferences',
  WHITELIST: 'whitelist',
  BYPASS: 'tab-bypass',
  BROADCAST_MESSAGES: 'broadcast-messages',
  VISITED_URLS_IN_TAB: 'visited-urls-in-tabs',
});

export const PREFERENCE_LEVELS = Object.freeze({
  BLOCK: 'Block',
  WARN: 'Warn',
  ALLOW: 'Allow',
});
export const PREFERENCE_LEVEL_UNKNOWN = 'Unknown';

export const POLICY_PROCESSING_STATUS = Object.freeze({
  PENDING: 'pending',
  PROCESSING: 'processing',
  DONE: 'done',
  ERROR: 'error',
});

export const ICON_OVERLAY_COLORS = Object.freeze({
  BLOCK: 'rgba(255, 82, 82, 1)',
  WARN: 'rgba(255, 216, 99, 1)',
  SUCCESS: 'rgba(0, 148, 64, 1)',
  UNKNOWN: 'rgba(192, 192, 192, 1)',
});

export const SLIDER_COLORS = Object.freeze({
  [PREFERENCE_LEVELS.BLOCK]: 'rgba(255, 82, 82, 1)',
  [PREFERENCE_LEVELS.WARN]: 'rgba(255, 216, 99, 1)',
  [PREFERENCE_LEVELS.ALLOW]: 'rgba(0, 148, 64, 1)',
  UNDEFINED: 'rgba(192, 192, 192, 1)',
  [PREFERENCE_LEVEL_UNKNOWN]: 'rgba(192, 192, 192, 1)',
});

export const LOGEVENTS = Object.freeze({
  ERROR: 'error',
  INSTALL: 'install',
  UNINSTALL: 'uninstall',
  UUID_SET: 'uuid_set',

  PAGEVISIT: 'page_visit',

  PREFERENCE_CHANGED: 'preference_changed',

  OPEN_POPUP: 'open_popup',
  CLOSE_POPUP: 'close_popup',
  OPEN_SIDEPANEL: 'open_sidepanel',
  CLOSE_SIDEPANEL: 'close_sidepanel',

  NAVIGATE_TO_ABOUT: 'navigate_to_about',
  NAVIGATE_TO_VIOLATIONS: 'navigate_to_violations',
  NAVIGATE_TO_PREFERENCES: 'navigate_to_preferences',
  NAVIGATE_TO_WHITELIST: 'navigate_to_whitelist',

  SHOW_BLOCKER: 'show_blocker',
  HIDE_BLOCKER: 'hide_blocker',
  IGNORE_WARNING: 'ignore_warning',
  LEAVE_PAGE: 'leave_page',
  ADD_WHITELIST: 'add_whitelist',
  REMOVE_WHITELIST: 'remove_whitelist',

  RECEIVED_SYSTEM_BROADCAST: 'received_system_broadcast'
});

export const MESSAGE_TYPES = Object.freeze({
  LOG: 'p4p:log',
  CLOSE_TAB: 'p4p:closeTab',
  REFRESH_SIDEPANEL: 'p4p:refreshSidepanel',
  SHOW_SETTINGS: 'p4p:showSettings',
  ADD_EXCEPTION: 'p4p:addException',
  SHOW_OVERLAY: 'p4p:showOverlay',
  HIDE_OVERLAY: 'p4p:hideOverlay',
  PREFERENCES_CHANGED: 'p4p:preferencesChanged',
  RECEIVED_REMOTE_DATA: 'p4p:receivedRemoteData',
  IGNORE_WARNING: 'p4p:ignoreWarning',
});
