export const RECIPIENTS = {
  "ours": {
    name: "Ours",
    description: "Information is used only by the entity collecting it and not shared with third parties."
  },
  "delivery": {
    name: "Delivery Services",
    description: "Information is shared with third parties only as needed to complete a transaction or deliver goods or services requested by the user."
  },
  "same": {
    name: "Same Entity",
    description: "Information may be shared with legal entities that are functionally or organizationally part of the same company or group as the collector."
  },
  "other-recipient": {
    name: "Other Recipient",
    description: "Information may be shared with other third parties whose practices may not be covered by the same privacy policy."
  },
  "unrelated": {
    name: "Unrelated Third Parties",
    description: "Information may be shared with companies or organizations that are neither part of the collector's company nor directly involved in providing the requested service."
  },
  "public": {
    name: "Public Disclosure",
    description: "Information may be made publicly available, meaning it can be accessed or viewed by anyone."
  }
};

export const PURPOSE = {
  "current": {
    name: "Current Transaction",
    description: "Information is used to complete the current activity or transaction requested by the user."
  },
  "admin": {
    name: "Administrative Use",
    description: "Information is used for technical support, website administration, or operational purposes."
  },
  "develop": {
    name: "Research and Development",
    description: "Information is used to improve, develop, or test new products, services, or system features."
  },
  "tailoring": {
    name: "Customization/Tailoring",
    description: "Information is used to customize or personalize content, services, or products for the user."
  },
  "pseudo-analysis": {
    name: "Pseudonymous Analysis",
    description: "Information is analyzed in a pseudonymous form, without directly identifying the individual."
  },
  "pseudo-decision": {
    name: "Pseudonymous Decision Making",
    description: "Information in pseudonymous form is used to influence or make decisions relevant to the user (e.g., targeted offers)."
  },
  "individual-analysis": {
    name: "Individual-Level Analysis",
    description: "Information is analyzed at the individual level to create profiles, insights, or decision-making outcomes tied to the user."
  },
  "individual-decision": {
    name: "Individual Decision Making",
    description: "Information is used directly to make decisions or take actions that affect the individual, such as eligibility, access, or offers."
  },
  "contact": {
    name: "Contacting the User",
    description: "Information is used to communicate with the user, such as responding to inquiries or providing service updates."
  },
  "historical": {
    name: "Historical Research",
    description: "Information is stored and used for historical, archival, or research purposes over time."
  },
  "telemarketing": {
    name: "Telemarketing",
    description: "Information is used to contact the user with marketing or promotional content via telephone or similar channels."
  },
  "other-purpose": {
    name: "Other Purpose",
    description: "Information is used for purposes not explicitly covered in the listed categories, as defined by the entity."
  }
};

export const RETENTION = {
  "no-retention": {
    name: "No Retention",
    description: "Information is not retained after it has been used for the immediate transaction or purpose."
  },
  "stated-purpose": {
    name: "Stated Purpose",
    description: "Information is retained only as long as necessary to fulfill the purposes explicitly stated in the privacy policy."
  },
  "legal-requirement": {
    name: "Legal Requirement",
    description: "Information is retained for as long as required by applicable law or regulation."
  },
  "business-practices": {
    name: "Business Practices",
    description: "Information is retained according to standard business practices, such as backup or audit procedures."
  },
  "indefinitely": {
    name: "Indefinitely",
    description: "Information is retained for an unlimited time without a predetermined deletion schedule."
  }
};

export const DATA_TYPES_BASE_FROM_SCHEMA = {
  "date.ymd.year": { name: "Year", description: "", key: "date.ymd.year" },
  "date.ymd.month": { name: "Month", description: "", key: "date.ymd.month" },
  "date.ymd.day": { name: "Day", description: "", key: "date.ymd.day" },
  "date.hms.hour": { name: "Hour", description: "", key: "date.hms.hour" },
  "date.hms.minute": { name: "Minute", description: "", key: "date.hms.minute" },
  "date.hms.second": { name: "Second", description: "", key: "date.hms.second" },
  "date.fractionsecond": { name: "Fraction of Second", description: "", key: "date.fractionsecond" },
  "date.timezone": { name: "Time Zone", description: "", key: "date.timezone" },
  "login.id": { name: "Login ID", description: "", key: "login.id" },
  "login.password": { name: "Login Password", description: "", key: "login.password" },
  "personname.prefix": { name: "Name Prefix", description: "", key: "personname.prefix" },
  "personname.given": { name: "Given Name (First Name)", description: "", key: "personname.given" },
  "personname.middle": { name: "Middle Name", description: "", key: "personname.middle" },
  "personname.family": { name: "Family Name (Last Name)", description: "", key: "personname.family" },
  "personname.suffix": { name: "Name Suffix", description: "", key: "personname.suffix" },
  "personname.nickname": { name: "Nickname", description: "", key: "personname.nickname" },
  "certificate.key": { name: "Certificate key", description: "", key: "certificate.key" },
  "certificate.format": { name: "Certificate format", description: "", key: "certificate.format" },
  "telephonenum.intcode": { name: "International Telephone Code", description: "", key: "telephonenum.intcode" },
  "telephonenum.loccode": { name: "Local Telephone Area Code", description: "", key: "telephonenum.loccode" },
  "telephonenum.number": { name: "Telephone Number", description: "", key: "telephonenum.number" },
  "telephonenum.ext": { name: "Telephone Extension", description: "", key: "telephonenum.ext" },
  "telephonenum.comment": { name: "Telephone Optional Comments", description: "", key: "telephonenum.comment" },
  "postal.name": { name: "Postal Name", description: "", key: "postal.name" },
  "postal.street": { name: "Street Address", description: "", key: "postal.street" },
  "postal.city": { name: "City", description: "", key: "postal.city" },
  "postal.stateprov": { name: "State or Province", description: "", key: "postal.stateprov" },
  "postal.postalcode": { name: "Postal Code", description: "", key: "postal.postalcode" },
  "postal.organization": { name: "Organization Name", description: "", key: "postal.organization" },
  "postal.country": { name: "Country Name", description: "", key: "postal.country" },
  "telecom.telephone": { name: "Telephone Number", description: "", key: "telecom.telephone" },
  "telecom.fax": { name: "Fax Number", description: "", key: "telecom.fax" },
  "telecom.mobile": { name: "Mobile Telephone Number", description: "", key: "telecom.mobile" },
  "telecom.pager": { name: "Pager Number", description: "", key: "telecom.pager" },
  "online.email": { name: "Email Address", description: "", key: "online.email" },
  "online.uri": { name: "Home Page Address", description: "", key: "online.uri" },
  "contact.postal": { name: "Postal Address Information", description: "", key: "contact.postal" },
  "contact.telecom": { name: "Telecommunications Information", description: "", key: "contact.telecom" },
  "contact.online": { name: "Online Address Information", description: "", key: "contact.online" },
  "uri.authority": { name: "URI Authority", description: "", key: "uri.authority" },
  "uri.stem": { name: "URI Stem", description: "", key: "uri.stem" },
  "uri.querystring": { name: "Query-string Portion of URI", description: "", key: "uri.querystring" },
  "ipaddr.hostname": { name: "Complete Host and Domain Name", description: "", key: "ipaddr.hostname" },
  "ipaddr.partialhostname": { name: "Partial Hostname", description: "", key: "ipaddr.partialhostname" },
  "ipaddr.fullip": { name: "Full IP Address", description: "", key: "ipaddr.fullip" },
  "ipaddr.partialip": { name: "Partial IP Address", description: "", key: "ipaddr.partialip" },
  "loginfo.uri": { name: "URI of Requested Resource", description: "", key: "loginfo.uri" },
  "loginfo.timestamp": { name: "Request Timestamp", description: "", key: "loginfo.timestamp" },
  "loginfo.clientip": { name: "Client's IP Address or Hostname", description: "", key: "loginfo.clientip" },
  "loginfo.other.httpmethod": { name: "HTTP Request Method", description: "", key: "loginfo.other.httpmethod" },
  "loginfo.other.bytes": { name: "Data Bytes in Response", description: "", key: "loginfo.other.bytes" },
  "loginfo.other.statuscode": { name: "Response Status Code", description: "", key: "loginfo.other.statuscode" },
  "httpinfo.referer": { name: "Last URI Requested by the User", description: "", key: "httpinfo.referer" },
  "httpinfo.useragent": { name: "User Agent Information", description: "", key: "httpinfo.useragent" },
  "dynamic.clickstream": { name: "Click-stream Information", description: "", key: "dynamic.clickstream" },
  "dynamic.http": { name: "HTTP Protocol Information", description: "", key: "dynamic.http" },
  "dynamic.clientevents": { name: "User's Interaction with a Resource", description: "", key: "dynamic.clientevents" },
  "dynamic.cookies": { name: "Use of HTTP Cookies", description: "", key: "dynamic.cookies" },
  "dynamic.searchtext": { name: "Search Terms", description: "", key: "dynamic.searchtext" },
  "dynamic.interactionrecord": { name: "Server Stores the Transaction History", description: "", key: "dynamic.interactionrecord" },
  "dynamic.miscdata": { name: "Other", description: "", key: "dynamic.miscdata" },
  "user.name": { name: "User's Name", description: "", key: "user.name" },
  "user.bdate": { name: "User's Birth Date", description: "", key: "user.bdate" },
  "user.login": { name: "User's Login Information", description: "", key: "user.login" },
  "user.cert": { name: "User's Identity Certificate", description: "", key: "user.cert" },
  "user.gender": { name: "User's Gender", description: "", key: "user.gender" },
  "user.jobtitle": { name: "User's Job Title", description: "", key: "user.jobtitle" },
  "user.home-info": { name: "User's Home Contact Information", description: "", key: "user.home-info" },
  "user.business-info": { name: "User's Business Contact Information", description: "", key: "user.business-info" },
  "user.employer": { name: "Name of User's Employer", description: "", key: "user.employer" },
  "user.department": { name: "Department or Division of Organization where User is Employed", description: "", key: "user.department" },
  "thirdparty.name": { name: "Third Party's Name", description: "", key: "thirdparty.name" },
  "thirdparty.bdate": { name: "Third Party's Birth Date", description: "", key: "thirdparty.bdate" },
  "thirdparty.login": { name: "Third Party's Login Information", description: "", key: "thirdparty.login" },
  "thirdparty.cert": { name: "Third Party's Identity Certificate", description: "", key: "thirdparty.cert" },
  "thirdparty.gender": { name: "Third Party's Gender", description: "", key: "thirdparty.gender" },
  "thirdparty.jobtitle": { name: "Third Party's Job Title", description: "", key: "thirdparty.jobtitle" },
  "thirdparty.home-info": { name: "Third Party's Home Contact Information", description: "", key: "thirdparty.home-info" },
  "thirdparty.business-info": { name: "Third Party's Business Contact Information", description: "", key: "thirdparty.business-info" },
  "thirdparty.employer": { name: "Name of Third Party's Employer", description: "", key: "thirdparty.employer" },
  "thirdparty.department": { name: "Department or Division of Organization where Third Party is Employed", description: "", key: "thirdparty.department" },
  "business.name": { name: "Organization Name", description: "", key: "business.name" },
  "business.department": { name: "Department or Division of Organization", description: "", key: "business.department" },
  "business.cert": { name: "Organization Identity certificate", description: "", key: "business.cert" },
  "business.contact-info": { name: "Contact Information for the Organization", description: "", key: "business.contact-info" },
};


export const DATA_TYPES_BASE = {
  "background.information": {
    "description": "General background information that may be collected, such as non-sensitive contextual details.",
    "key": "background.information",
    "name": "Background Information"
  },
  "basic.personal.identifiers": {
    "description": "Identifiers that can uniquely recognize an individual, such as name, ID number, or other unique attributes.",
    "key": "basic.personal.identifiers",
    "name": "Basic Personal Identifiers"
  },
  "biometric.information": {
    "description": "Biometric data including fingerprints, facial recognition, voiceprints, or other physical or behavioral identifiers.",
    "key": "biometric.information",
    "name": "Biometric Information"
  },
  "business.contact-info": {
    "description": "Professional or business-related contact information such as work phone, work email, or office address.",
    "key": "business.contact-info",
    "name": "Business Contact Information"
  },
  "commercial.information": {
    "description": "Commercial details such as products purchased, purchase history, services used, or preferences.",
    "key": "commercial.information",
    "name": "Commercial Information"
  },
  "communications": {
    "description": "Records of communications including messages, chats, phone calls, or emails.",
    "key": "communications",
    "name": "Communications"
  },
  "demographic.information": {
    "description": "Demographic details such as age, gender, ethnicity, marital status, or household data.",
    "key": "demographic.information",
    "name": "Demographic Information"
  },
  "device.online.identifiers": {
    "description": "Online identifiers assigned to a device, browser, or session, including cookies, IP addresses, or device IDs.",
    "key": "device.online.identifiers",
    "name": "Device Online Identifiers"
  },
  "dynamic.accesslog": {
    "description": "System-generated access logs, such as server requests, login timestamps, or IP usage logs.",
    "key": "dynamic.accesslog",
    "name": "Access Logs"
  },
  "dynamic.activity": {
    "description": "Activity records showing user interactions, behaviors, and usage of services or applications.",
    "key": "dynamic.activity",
    "name": "Activity Data"
  },
  "dynamic.ads": {
    "description": "Advertising-related data such as ads viewed, clicks, or engagement with marketing campaigns.",
    "key": "dynamic.ads",
    "name": "Ads Data"
  },
  "dynamic.advertising": {
    "description": "Data related to online advertising such as targeted campaigns, impressions, and ad personalization.",
    "key": "dynamic.advertising",
    "name": "Advertising Information"
  },
  "dynamic.aggregated-data": {
    "description": "Data that has been aggregated or anonymized to show patterns without identifying individuals.",
    "key": "dynamic.aggregated-data",
    "name": "Aggregated Data"
  },
  "dynamic.analytics": {
    "description": "Analytics data, including website or app usage metrics, performance statistics, and engagement levels.",
    "key": "dynamic.analytics",
    "name": "Analytics Data"
  },
  "dynamic.avdocuments": {
    "description": "Audio, video, or document files uploaded or generated by users.",
    "key": "dynamic.avdocuments",
    "name": "Audio/Video Documents"
  },
  "dynamic.biometric": {
    "description": "Biometric records collected dynamically, such as voice samples or real-time facial recognition data.",
    "key": "dynamic.biometric",
    "name": "Biometric Data"
  },
  "dynamic.clickstream": {
    "description": "Clickstream data showing navigation paths, clicks, and browsing behavior.",
    "key": "dynamic.clickstream",
    "name": "Clickstream Data"
  },
  "dynamic.cloud.chats": {
    "description": "Chat messages or communication logs stored in cloud-based services.",
    "key": "dynamic.cloud.chats",
    "name": "Cloud Chat Data"
  },
  "dynamic.comments": {
    "description": "User-generated comments, posts, or feedback shared on platforms.",
    "key": "dynamic.comments",
    "name": "User Comments"
  },
  "dynamic.contactDPO": {
    "description": "Contact data for a Data Protection Officer (DPO) or privacy representative.",
    "key": "dynamic.contactDPO",
    "name": "Data Protection Officer Contact"
  },
  "dynamic.content": {
    "description": "General user-generated or system-provided content such as posts, images, or documents.",
    "key": "dynamic.content",
    "name": "Content"
  },
  "dynamic.context": {
    "description": "Contextual information describing the environment or situation in which data is collected.",
    "key": "dynamic.context",
    "name": "Context Data"
  },
  "dynamic.cookies": {
    "description": "Cookie information stored on a device to track sessions, preferences, or identifiers.",
    "key": "dynamic.cookies",
    "name": "Cookies"
  },
  "dynamic.customer-content": {
    "description": "Content provided by customers, such as uploaded files, notes, or stored documents.",
    "key": "dynamic.customer-content",
    "name": "Customer Content"
  },
  "dynamic.device": {
    "description": "Device-related data including model, type, or operating system.",
    "key": "dynamic.device",
    "name": "Device Data"
  },
  "dynamic.device-info": {
    "description": "Technical device information such as hardware specifications, OS version, and performance details.",
    "key": "dynamic.device-info",
    "name": "Device Information"
  },
  "dynamic.device.information": {
    "description": "Collected device-specific details including identifiers, connectivity, and system settings.",
    "key": "dynamic.device.information",
    "name": "Device Information (Extended)"
  },
  "dynamic.deviceid": {
    "description": "Unique identifiers assigned to a device, such as IMEI, MAC address, or advertising IDs.",
    "key": "dynamic.deviceid",
    "name": "Device ID"
  },
  "dynamic.deviceinfo": {
    "description": "General information about user devices, such as browser type, device category, or installed apps.",
    "key": "dynamic.deviceinfo",
    "name": "Device Info"
  },
  "dynamic.geo-location": {
    "description": "Geographic location information such as GPS data, latitude/longitude, or location history.",
    "key": "dynamic.geo-location",
    "name": "Geolocation Data"
  },
  "dynamic.http": {
    "description": "Data transmitted via HTTP requests, including headers and request metadata.",
    "key": "dynamic.http",
    "name": "HTTP Data"
  },
  "dynamic.http.useragent": {
    "description": "Information from the browser’s user-agent string, such as browser version and OS details.",
    "key": "dynamic.http.useragent",
    "name": "HTTP User-Agent"
  },
  "dynamic.ip": {
    "description": "Internet Protocol (IP) identifiers associated with a user’s network activity.",
    "key": "dynamic.ip",
    "name": "IP Data"
  },
  "dynamic.ip.address": {
    "description": "The IP address assigned to a device or user at a given time.",
    "key": "dynamic.ip.address",
    "name": "IP Address"
  },
  "dynamic.ipaddress": {
    "description": "Collected IP address information in any form.",
    "key": "dynamic.ipaddress",
    "name": "IP Address Data"
  },
  "dynamic.legal": {
    "description": "Legal information related to compliance, disputes, or agreements.",
    "key": "dynamic.legal",
    "name": "Legal Information"
  },
  "dynamic.legalrequests": {
    "description": "Data related to legal inquiries, subpoenas, or government requests.",
    "key": "dynamic.legalrequests",
    "name": "Legal Requests"
  },
  "dynamic.location": {
    "description": "General location data, such as approximate city, region, or country.",
    "key": "dynamic.location",
    "name": "Location Data"
  },
  "dynamic.logfiles": {
    "description": "Log files containing technical and security-related system records.",
    "key": "dynamic.logfiles",
    "name": "Log Files"
  },
  "dynamic.metadata": {
    "description": "Metadata about files, communications, or system interactions (e.g., timestamps, file properties).",
    "key": "dynamic.metadata",
    "name": "Metadata"
  },
  "dynamic.miscdata": {
    "description": "Miscellaneous collected data not categorized elsewhere.",
    "key": "dynamic.miscdata",
    "name": "Miscellaneous Data"
  },
  "dynamic.network.activity": {
    "description": "Details of network activity including connections, requests, and traffic logs.",
    "key": "dynamic.network.activity",
    "name": "Network Activity"
  },
  "dynamic.nodata": {
    "description": "Indicates that no data is collected in this category.",
    "key": "dynamic.nodata",
    "name": "No Data"
  },
  "dynamic.participant.data": {
    "description": "Information about participants in events, surveys, or online sessions.",
    "key": "dynamic.participant.data",
    "name": "Participant Data"
  },
  "dynamic.paymentinfo": {
    "description": "Payment-related information such as card details, billing data, or payment confirmations.",
    "key": "dynamic.paymentinfo",
    "name": "Payment Information"
  },
  "dynamic.personaldata": {
    "description": "General personal data collected about an individual.",
    "key": "dynamic.personaldata",
    "name": "Personal Data"
  },
  "dynamic.processing": {
    "description": "Information about data processing activities or how data is handled internally.",
    "key": "dynamic.processing",
    "name": "Processing Information"
  },
  "dynamic.protection": {
    "description": "Details about data protection measures applied to user information.",
    "key": "dynamic.protection",
    "name": "Data Protection Information"
  },
  "dynamic.publiccontributions": {
    "description": "User-generated contributions that are publicly visible (e.g., forum posts, public comments).",
    "key": "dynamic.publiccontributions",
    "name": "Public Contributions"
  },
  "dynamic.retention": {
    "description": "Information on how long data is stored or retained.",
    "key": "dynamic.retention",
    "name": "Retention Information"
  },
  "dynamic.retention-policy": {
    "description": "Specific details of the retention policies governing stored data.",
    "key": "dynamic.retention-policy",
    "name": "Retention Policy"
  },
  "dynamic.rights": {
    "description": "Information about user rights regarding their personal data.",
    "key": "dynamic.rights",
    "name": "Data Rights"
  },
  "dynamic.searchqueries": {
    "description": "Search queries submitted by a user, including keywords and phrases.",
    "key": "dynamic.searchqueries",
    "name": "Search Queries"
  },
  "dynamic.security": {
    "description": "Security-related information such as authentication data, threats, or detected risks.",
    "key": "dynamic.security",
    "name": "Security Information"
  },
  "dynamic.security.verification": {
    "description": "Data collected for identity and security verification purposes.",
    "key": "dynamic.security.verification",
    "name": "Security Verification"
  },
  "dynamic.securitymeasures": {
    "description": "Details of security measures applied, such as encryption, firewalls, or access controls.",
    "key": "dynamic.securitymeasures",
    "name": "Security Measures"
  },
  "dynamic.session": {
    "description": "Data about user sessions such as session tokens, durations, and activity states.",
    "key": "dynamic.session",
    "name": "Session Data"
  },
  "dynamic.sharing": {
    "description": "Information about how and with whom data is shared.",
    "key": "dynamic.sharing",
    "name": "Sharing Information"
  },
  "dynamic.terms": {
    "description": "Information about terms of service or policy agreements.",
    "key": "dynamic.terms",
    "name": "Terms Information"
  },
  "dynamic.updates": {
    "description": "Updates to policies, services, or user agreements.",
    "key": "dynamic.updates",
    "name": "Updates"
  },
  "dynamic.usage": {
    "description": "Data on how services, websites, or applications are used.",
    "key": "dynamic.usage",
    "name": "Usage Data"
  },
  "dynamic.usage-data": {
    "description": "Specific details of user usage patterns such as time spent, features used, or frequency.",
    "key": "dynamic.usage-data",
    "name": "Usage Data (Detailed)"
  },
  "dynamic.usage-info": {
    "description": "General information about usage behavior and trends.",
    "key": "dynamic.usage-info",
    "name": "Usage Information"
  },
  "dynamic.usageinfo": {
    "description": "Additional usage information not captured elsewhere.",
    "key": "dynamic.usageinfo",
    "name": "Usage Info"
  },
  "dynamic.user.activity": {
    "description": "Details of specific user activities within a service or platform.",
    "key": "dynamic.user.activity",
    "name": "User Activity"
  },
  "dynamic.user.preferences": {
    "description": "User settings, preferences, and customizations.",
    "key": "dynamic.user.preferences",
    "name": "User Preferences"
  },
  "dynamic.useragent": {
    "description": "Browser or client user-agent string information.",
    "key": "dynamic.useragent",
    "name": "User-Agent"
  },
  "dynamic.userdata": {
    "description": "General information about users collected during interactions.",
    "key": "dynamic.userdata",
    "name": "User Data"
  },
  "financial.information": {
    "description": "Financial records such as account balances, bank details, or transaction histories.",
    "key": "financial.information",
    "name": "Financial Information"
  },
  "geolocation": {
    "description": "Precise or approximate location information collected via GPS, Wi-Fi, or IP data.",
    "key": "geolocation",
    "name": "Geolocation Data"
  },
  "inferences": {
    "description": "Inferences drawn from data, such as predicted preferences, interests, or behaviors.",
    "key": "inferences",
    "name": "Inferred Data"
  },
  "internet.network.activity": {
    "description": "Details of internet activity, including browsing history, interactions, and connections.",
    "key": "internet.network.activity",
    "name": "Internet Network Activity"
  },
  "sensory.information": {
    "description": "Sensory data such as audio, visual, smell, touch, or other perception-related inputs.",
    "key": "sensory.information",
    "name": "Sensor Data"
  },
  "user.account-info": {
    "description": "General information about a user’s account, such as account ID or type.",
    "key": "user.account-info",
    "name": "Account Information"
  },
  "user.account.closing": {
    "description": "Details about account closure requests or termination records.",
    "key": "user.account.closing",
    "name": "Account Closing Data"
  },
  "user.account.data": {
    "description": "General data stored in or linked to a user account.",
    "key": "user.account.data",
    "name": "Account Data"
  },
  "user.account.settings": {
    "description": "Configuration and preference settings linked to a user account.",
    "key": "user.account.settings",
    "name": "Account Settings"
  },
  "user.address": {
    "description": "Physical address of the user, such as home or mailing address.",
    "key": "user.address",
    "name": "Address"
  },
  "user.affiliation": {
    "description": "Affiliation details such as employer, school, organization, or group memberships.",
    "key": "user.affiliation",
    "name": "Affiliation"
  },
  "user.age": {
    "description": "Age or age range of the user.",
    "key": "user.age",
    "name": "Age"
  },
  "user.bdate.ymd.year": {
    "description": "The year of the user’s birth.",
    "key": "user.bdate.ymd.year",
    "name": "Birth Year"
  },
  "user.billing.address": {
    "description": "Billing address associated with financial transactions.",
    "key": "user.billing.address",
    "name": "Billing Address"
  },
  "user.birthday": {
    "description": "The user’s full date of birth.",
    "key": "user.birthday",
    "name": "Birthday"
  },
  "user.browser": {
    "description": "The web browser used by the user, including version and vendor.",
    "key": "user.browser",
    "name": "Browser"
  },
  "user.business-info.postal": {
    "description": "Postal address associated with a user’s business or workplace.",
    "key": "user.business-info.postal",
    "name": "Business Postal Information"
  },
  "user.business-info.telecom.telephone": {
    "description": "Telephone number linked to a user’s business or workplace.",
    "key": "user.business-info.telecom.telephone",
    "name": "Business Telephone"
  },
  "user.consent": {
    "description": "Information about user consent for data collection or processing.",
    "key": "user.consent",
    "name": "Consent"
  },
  "user.contact.info": {
    "description": "General contact information such as phone, email, or address.",
    "key": "user.contact.info",
    "name": "Contact Information"
  },
  "user.content": {
    "description": "User-generated content such as posts, uploads, or shared files.",
    "key": "user.content",
    "name": "Content"
  },
  "user.country": {
    "description": "Country of residence or origin for the user.",
    "key": "user.country",
    "name": "Country"
  },
  "user.data.request": {
    "description": "Requests made by a user regarding their data (e.g., access or deletion).",
    "key": "user.data.request",
    "name": "Data Request"
  },
  "user.disability": {
    "description": "Information related to user disability or accessibility needs.",
    "key": "user.disability",
    "name": "Disability Information"
  },
  "user.email": {
    "description": "The user’s email address.",
    "key": "user.email",
    "name": "Email"
  },
  "user.ethnicity": {
    "description": "User’s ethnic background information.",
    "key": "user.ethnicity",
    "name": "Ethnicity"
  },
  "user.financial-info": {
    "description": "Financial details such as income, bank accounts, or transaction data.",
    "key": "user.financial-info",
    "name": "Financial Information"
  },
  "user.gender": {
    "description": "The user’s gender identity.",
    "key": "user.gender",
    "name": "Gender"
  },
  "user.generated-content": {
    "description": "Any content created and uploaded by the user.",
    "key": "user.generated-content",
    "name": "Generated Content"
  },
  "user.home-info.online.email": {
    "description": "Personal/home email address of the user.",
    "key": "user.home-info.online.email",
    "name": "Home Email"
  },
  "user.home-info.postal": {
    "description": "Home postal address of the user.",
    "key": "user.home-info.postal",
    "name": "Home Postal Address"
  },
  "user.home-info.telecom.telephone": {
    "description": "Home telephone number of the user.",
    "key": "user.home-info.telecom.telephone",
    "name": "Home Telephone"
  },
  "user.input": {
    "description": "Data manually input by the user, such as forms or survey entries.",
    "key": "user.input",
    "name": "Input Data"
  },
  "user.location": {
    "description": "User’s location details, either approximate or precise.",
    "key": "user.location",
    "name": "Location"
  },
  "user.login.id": {
    "description": "The username or login identifier used to access a service.",
    "key": "user.login.id",
    "name": "Login ID"
  },
  "user.login.password": {
    "description": "The password associated with a user’s login credentials.",
    "key": "user.login.password",
    "name": "Login Password"
  },
  "user.name": {
    "description": "The user’s full name or chosen display name.",
    "key": "user.name",
    "name": "Name"
  },
  "user.password": {
    "description": "The password chosen or stored for account access.",
    "key": "user.password",
    "name": "Password"
  },
  "user.payment-info": {
    "description": "Payment-related details such as credit card numbers or billing accounts.",
    "key": "user.payment-info",
    "name": "Payment Information"
  },
  "user.payment.info": {
    "description": "Collected data about user payment methods or transactions.",
    "key": "user.payment.info",
    "name": "Payment Info"
  },
  "user.payment.method": {
    "description": "The payment method chosen by the user (e.g., credit card, PayPal, bank transfer).",
    "key": "user.payment.method",
    "name": "Payment Method"
  },
  "user.personalinfo": {
    "description": "Personal details about the user not covered in other categories.",
    "key": "user.personalinfo",
    "name": "Personal Information"
  },
  "user.phone": {
    "description": "User’s phone number in general form.",
    "key": "user.phone",
    "name": "Phone"
  },
  "user.phone.number": {
    "description": "Specific phone number used by the user.",
    "key": "user.phone.number",
    "name": "Phone Number"
  },
  "user.preferences": {
    "description": "Preferences and choices indicated by the user.",
    "key": "user.preferences",
    "name": "Preferences"
  },
  "user.profile.picture": {
    "description": "Profile picture or avatar uploaded by the user.",
    "key": "user.profile.picture",
    "name": "Profile Picture"
  },
  "user.race": {
    "description": "Information on the user’s racial background.",
    "key": "user.race",
    "name": "Race"
  },
  "user.request": {
    "description": "Requests made by the user to the service or platform.",
    "key": "user.request",
    "name": "Request"
  },
  "user.requestconfirmation": {
    "description": "Confirmation details for user-submitted requests.",
    "key": "user.requestconfirmation",
    "name": "Request Confirmation"
  },
  "user.sexual.orientation": {
    "description": "User’s sexual orientation, when disclosed or collected.",
    "key": "user.sexual.orientation",
    "name": "Sexual Orientation"
  },
  "user.shipping-info": {
    "description": "Shipping address or delivery-related data for the user.",
    "key": "user.shipping-info",
    "name": "Shipping Information"
  },
  "user.surveys": {
    "description": "Responses or participation data from surveys completed by the user.",
    "key": "user.surveys",
    "name": "Survey Data"
  },
  "user.telephone": {
    "description": "Telephone information linked to the user.",
    "key": "user.telephone",
    "name": "Telephone"
  },
  "user.uploadedcontent": {
    "description": "Content uploaded by the user, such as files, photos, or media.",
    "key": "user.uploadedcontent",
    "name": "Uploaded Content"
  },
  "user.username": {
    "description": "The username chosen by or assigned to the user.",
    "key": "user.username",
    "name": "Username"
  }
};


export const CATEGORIES = {
    background: 'Background Information',
    basic: 'Basic Information',
    biometric: 'Biometric Data',
    business: 'Business Information',
    commercial: 'Commercial Information',
    communications: 'Communication Data',
    demographic: 'Demographic Data',
    device: 'Device Data',
    dynamic: 'Browser Data',
    financial: 'Financial Information',
    geolocation: 'Location Data',
    inferences: 'Inferences',
    internet: 'Technical Information',
    sensory: 'Sensor Data',
    user: 'User Data',

  // date: 'Date/Time data',
  // login: 'Login information',
  // personname: 'Person name',
  // certificate: 'Certificate data',
  // telephonenum: 'Phone related data',
  // postal: 'Postal data',
  // telecom: 'Phone related data',
  // online: 'Your Online Presence',
  // contact: 'Contact information',
  // uri: 'URI',
  // ipaddr: 'IP Address',
  // loginfo: 'Login information',
  // httpinfo: 'HTTP information',
  // dynamic: 'Dynamic data',
  // user: 'User data',
  // thirdparty: 'Third party data',
  // business: 'Business data'
};
